Attribute VB_Name = "StatsString"
Option Explicit

Public Sub sprintf(ByRef Source As String, ByVal nText As String, _
    Optional ByVal a As Variant, _
    Optional ByVal b As Variant, _
    Optional ByVal c As Variant, _
    Optional ByVal D As Variant, _
    Optional ByVal E As Variant, _
    Optional ByVal F As Variant, _
    Optional ByVal G As Variant, _
    Optional ByVal H As Variant)
    
    nText = Replace(nText, "%S", "%s")
    Dim I As Byte
    I = 0
    Do While (InStr(1, nText, "%s") <> 0)
        Select Case I
            Case 0
                If IsEmpty(a) Then GoTo TheEnd
                nText = Replace(nText, "%s", a, 1, 1)
            Case 1
                If IsEmpty(b) Then GoTo TheEnd
                nText = Replace(nText, "%s", b, 1, 1)
            Case 2
                If IsEmpty(c) Then GoTo TheEnd
                nText = Replace(nText, "%s", c, 1, 1)
            Case 3
                If IsEmpty(D) Then GoTo TheEnd
                nText = Replace(nText, "%s", D, 1, 1)
            Case 4
                If IsEmpty(E) Then GoTo TheEnd
                nText = Replace(nText, "%s", E, 1, 1)
            Case 5
                If IsEmpty(F) Then GoTo TheEnd
                nText = Replace(nText, "%s", F, 1, 1)
            Case 6
                If IsEmpty(G) Then GoTo TheEnd
                nText = Replace(nText, "%s", G, 1, 1)
            Case 7
                If IsEmpty(H) Then GoTo TheEnd
                nText = Replace(nText, "%s", H, 1, 1)
        End Select
        I = I + 1
    Loop
TheEnd:
    Source = Source & nText
End Sub

Public Sub ParseStatString(ByVal statstring As String, ByRef outbuf As String)
    Dim Values() As String
    Dim cType As String
    'Dim Level As String, BestRace As String, BestRaceWins As String
    Select Case Left$(statstring, 4)
    'Case "WAR3"
    '        Dim War3Races(0 To 5) As String
    '            War3Races(0) = "random"
    '           War3Races(1) = "humans"
    '            War3Races(2) = "orcs"
    '            War3Races(3) = "undead"
    '            War3Races(4) = "night elves"
    '            War3Races(5) = "unknown"
    '        Dim Level As Integer, BestRace As String, BestRaceWins As Integer, StatBuf As String, teststatstring As String
    '        StatBuf = "Warcraft III: Reign of Chaos ("
    '        teststatstringArray = Split(Mid(teststatstring, 6), " ")
    '        If UBound(teststatstringArray) = 2 Then
    '            Level = teststatstringArray(0)
    '            BestRace = teststatstringArray(1)
    '            BestRaceWins = teststatstringArray(2)
    '            If BestRace > 4 Or BestRace < 0 Then
    '                BestRace = 5
    '            End If
    '            StatBuf = StatBuf & "level " & Level & ", best race " & War3Races(BestRace) & ", " & BestRaceWins & " win" & IIf(BestRaceWins = 1, ")", "s)")
    '        ElseIf Len(teststatstring) = 4 Then
    '            StatBuf = StatBuf & "No information available)"
    '        Else
    '            StatBuf = StatBuf & "unrecognized format: " & Chr(34) & Mid(teststatstring, 6) & Chr(34) & ")"
    '        End If
        Case "3RAW"
            sprintf outbuf, "WarCraft III Reign of Chaos ("
            If Len(statstring) > 4 Then
                Values = Split(statstring, " ")
                    Select Case Mid$(Values(1), 1, 1)
                        Case 1: strcpy outbuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1)) & " Icon, "
                        Case 2: strcpy outbuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1)) & " Icon, "
                        Case 3: strcpy outbuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1)) & " Icon, "
                        Case 4: strcpy outbuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1)) & " Icon, "
                        Case Else: strcpy outbuf, "Unknown icon " & Mid$(Values(1), 1, 1) & ", "
                    End Select
                    Select Case Mid$(Values(1), 2, 1)
                        Case "H": strcpy outbuf, "Human Race, "
                        Case "O": strcpy outbuf, "Orc Race, "
                        Case "N": strcpy outbuf, "Night Elf Race, "
                        Case "U": strcpy outbuf, "Undead Race, "
                        Case "R": strcpy outbuf, "Random Race, "
                        Case Else: strcpy outbuf, "Unknown Race, "
                    End Select
                    strcpy outbuf, "Level " & Values(2) & ")"
                Exit Sub
            ElseIf Len(statstring) = 4 Then
                strcpy outbuf, "No stats available)"
                Exit Sub
            Else
                strcpy outbuf, "Unknown Stats " & statstring & ")"
                Exit Sub
            End If
            Case "PX3W"
            sprintf outbuf, "WarCraft III Frozen Throne ("
            If Len(statstring) > 4 Then
                Values = Split(statstring, " ")
                    Select Case Mid$(Values(1), 1, 1)
                        Case 1: strcpy outbuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1)) & " Icon, "
                        Case 2: strcpy outbuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1)) & " Icon, "
                        Case 3: strcpy outbuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1)) & " Icon, "
                        Case 4: strcpy outbuf, GetIconTier(Mid$(Values(1), 1, 1), Mid$(Values(1), 2, 1)) & " Icon, "
                        Case Else: strcpy outbuf, "Unknown icon " & Mid$(Values(1), 1, 1) & ", "
                    End Select
                    Select Case Mid$(Values(1), 2, 1)
                        Case "H": strcpy outbuf, "Human Race, "
                        Case "O": strcpy outbuf, "Orc Race, "
                        Case "N": strcpy outbuf, "Night Elf Race, "
                        Case "U": strcpy outbuf, "Undead Race, "
                        Case "R": strcpy outbuf, "Random Race, "
                        Case Else: strcpy outbuf, "Unknown Race, "
                    End Select
                    strcpy outbuf, "Level " & Values(2) & ")"
                Exit Sub
            ElseIf Len(statstring) = 4 Then
                strcpy outbuf, "No stats available)"
                Exit Sub
            Else
                strcpy outbuf, "Unknown Stats " & statstring & ")"
                Exit Sub
            End If
            Case "RHSS"
            Call strcpy(outbuf, "Starcraft Shareware")
        Case "RATS"
            Values() = Split(Mid$(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call sprintf(outbuf, "a Starcraft %sbot", IIf((Values(3) = 1), " (spawn) ", ""))
                Exit Sub
            End If
            If Values(0) > 0 Then
                If Values(1) > 0 Then
                    Call sprintf(outbuf, "Starcraft%s (%s wins, and a rank of " & Values(1) & " with a rating of %s on the ladder)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                Else
                    Call sprintf(outbuf, "Starcraft%s (%s wins, and a rating of %s on the ladder)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                End If
            Else
                Call sprintf(outbuf, "Starcraft%s (%s wins)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2))
            End If
        Case "PXES"
            Values() = Split(Mid(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call sprintf(outbuf, "a Starcraft Brood War %sbot", IIf((Values(3) = 1), " (spawn) ", ""))
                Exit Sub
            End If
            If Values(0) > 0 Then
                If Values(1) > 0 Then
                    Call sprintf(outbuf, "Starcraft Brood War%s (%s wins, and a rank of " & Values(1) & " with a rating of %s on the ladder)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                Else
                    Call sprintf(outbuf, "Starcraft Brood War%s (%s wins, and a rating of %s on the ladder)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                End If
            Else
                Call sprintf(outbuf, "Starcraft Brood War%s (%s wins)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2))
            End If
        Case "RTSJ"
            Values() = Split(Mid(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call sprintf(outbuf, "a Starcraft Japanese %sbot", IIf((Values(3) = 1), " (spawn) ", ""))
                Exit Sub
            End If
            If Values(0) > 0 Then
                If Values(1) > 0 Then
                    Call sprintf(outbuf, "Starcraft Japanese%s (%s wins, and a rank of " & Values(1) & " with a rating of %s on the ladder)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                Else
                    Call sprintf(outbuf, "Starcraft Japanese%s (%s wins, and a rating of %s on the ladder)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
                End If
            Else
                Call sprintf(outbuf, "Starcraft Japanese%s (%s wins)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2))
            End If
        Case "NB2W"
            Values() = Split(Mid$(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call sprintf(outbuf, "a Warcraft II %sbot", IIf((Values(3) = 1), " (spawn) ", ""))
                Exit Sub
            End If
            If Values(0) > 0 Then
                Call sprintf(outbuf, "Warcraft II%s (%s wins, and a rank of " & Values(1) & " with a rating of %s on the ladder)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2), Values(0))
            Else
                Call sprintf(outbuf, "Warcraft II%s (%s wins)", IIf((Values(3) = 1), " (spawn) ", ""), Values(2))
            End If
        Case "RHSD"
            Values() = Split(Mid$(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call strcpy(outbuf, "a Diablo shareware bot")
                Exit Sub
            End If
            Select Case Values(2)
                Case 0: cType = "warrior"
                Case 1: cType = "rogue"
                Case 2: cType = "sorceror"
            End Select
            Call sprintf(outbuf, "Diablo shareware (Level %s %s with %s dots, %s strength, %s magic, %s dexterity, %s vitality, and %s gold)", Values(0), cType, Values(1), Values(3), Values(4), Values(5), Values(6), Values(7))
        Case "LTRD"
            Values() = Split(Mid$(statstring, 6), " ")
            If UBound(Values) <> 8 Then
                Call strcpy(outbuf, "a Diablo bot")
                Exit Sub
            End If
            Select Case Values(2)
                Case 0: cType = "warrior"
                Case 1: cType = "rogue"
                Case 2: cType = "sorceror"
            End Select
            Call sprintf(outbuf, "Diablo (Level %s %s with %s dots, %s strength, %s magic, %s dexterity, %s vitality, and %s gold)", Values(0), cType, Values(1), Values(3), Values(4), Values(5), Values(6), Values(7))
        Case "PX2D"
            Call strcpy(outbuf, ParseD2Stats(statstring))
        Case "VD2D"
            Call strcpy(outbuf, ParseD2Stats(statstring))
        Case "TAHC"
            Call strcpy(outbuf, "a Chat bot")
    End Select
End Sub

Public Function ParseD2Stats(ByVal Stats As String)
    Dim d2classes(0 To 7) As String
        d2classes(0) = "amazon"
        d2classes(1) = "sorceress"
        d2classes(2) = "necromancer"
        d2classes(3) = "paladin"
        d2classes(4) = "barbarian"
        d2classes(5) = "druid"
        d2classes(6) = "assassin"
        d2classes(7) = "unknown class"
    Dim StatBuf As String, P() As String, Server As String, Name As String
    If Len(Stats) > 4 Then
        Dim sLen As Byte
        sLen = GetServer(Stats, Server)
        sLen = GetCharacterName(Stats, sLen, Name)
        Call MakeArray(Mid$(Stats, sLen), P())
    End If
    If Left$(Stats, 4) = "VD2D" Then
        Call strcpy(StatBuf, "Diablo II (")
    Else
        Call strcpy(StatBuf, "Diablo II Lord of Destruction (")
    End If
    If (Len(Stats) = 4) Then
        Call strcpy(StatBuf, "Open Character)")
    Else
        Dim version As Byte
        version = Asc(P(0)) - &H80
        Dim charclass As Byte
        charclass = Asc(P(13)) - 1
        If (charclass < 0) Or (charclass > 6) Then
            charclass = 7
        End If
        Dim female As Boolean
        female = False
        If (charclass = 0) Or (charclass = 1) Or (charclass = 6) Then
            female = True
        End If
        Dim charlevel As Byte
        charlevel = Asc(P(25))
        Dim hardcore As Byte
        hardcore = Asc(P(26)) And 4
        Dim expansion As Boolean
        expansion = False
        If Left$(Stats, 4) = "PX2D" Then
            If (Asc(P(26)) And &H20) Then
                Select Case RShift((Asc(P(27)) And &H18), 3)
                    Case 1
                        If hardcore Then
                            Call strcpy(StatBuf, "Destroyer ")
                        Else
                            Call strcpy(StatBuf, "Slayer ")
                        End If
                    Case 2
                        If hardcore Then
                            Call strcpy(StatBuf, "Conquerer ")
                        Else
                            Call strcpy(StatBuf, "Champion ")
                        End If
                    Case 3
                        If hardcore Then
                            Call strcpy(StatBuf, "Guardian ")
                        Else
                            If Not female Then
                                Call strcpy(StatBuf, "Patriarch ")
                            Else
                                Call strcpy(StatBuf, "Matriarch ")
                            End If
                        End If
                End Select
                expansion = True
            End If
        End If
        If Not expansion Then
            Select Case RShift((Asc(P(27)) And &H18), 3)
                Case 1
                    If female = False Then
                        If hardcore Then
                            Call strcpy(StatBuf, "Count ")
                        Else
                            Call strcpy(StatBuf, "Sir ")
                        End If
                    Else
                        If hardcore Then
                            Call strcpy(StatBuf, "Countess ")
                        Else
                            Call strcpy(StatBuf, "Dame ")
                        End If
                    End If
                Case 2
                    If female = False Then
                        If hardcore Then
                            Call strcpy(StatBuf, "Duke ")
                        Else
                            Call strcpy(StatBuf, "Lord ")
                        End If
                    Else
                        If hardcore Then
                            Call strcpy(StatBuf, "Duchess ")
                        Else
                            Call strcpy(StatBuf, "Lady ")
                        End If
                    End If
                Case 3
                    If female = False Then
                        If hardcore Then
                            Call strcpy(StatBuf, "King ")
                        Else
                            Call strcpy(StatBuf, "Baron ")
                        End If
                    Else
                        If hardcore Then
                            Call strcpy(StatBuf, "Queen ")
                        Else
                            Call strcpy(StatBuf, "Baroness ")
                        End If
                    End If
            End Select
        End If
        Call sprintf(StatBuf, "%s a ", Name)
        If hardcore Then
            If (Asc(P(26)) And &H8) Then
                Call strcpy(StatBuf, "dead ")
            End If
            Call sprintf(StatBuf, "hardcore level %s ", charlevel)
        Else
            Call sprintf(StatBuf, "level %s ", charlevel)
        End If
        Call sprintf(StatBuf, "%s on realm %s)", d2classes(charclass), Server)
    End If
    ParseD2Stats = StatBuf
End Function

Private Function GetServer(ByVal statstring As String, ByRef Server As String) As Byte
    'returns the begining of the character name
    Server = Mid$(statstring, 5, InStr(5, statstring, ",") - 5)
    GetServer = InStr(5, statstring, ",") + 1
End Function

Private Function GetCharacterName(ByVal statstring As String, ByVal start As Byte, ByRef cName As String) As Byte
    cName = Mid$(statstring, start, InStr(start, statstring, ",") - start)
    GetCharacterName = InStr(start, statstring, ",") + 1
End Function

Private Sub MakeArray(ByVal text As String, ByRef nArray() As String)
    Dim I As Long
    ReDim nArray(0)
    For I = 0 To Len(text)
        nArray(I) = Mid$(text, I + 1, 1)
        If I <> Len(text) Then
            ReDim Preserve nArray(0 To UBound(nArray) + 1)
        End If
    Next I
End Sub
Public Function RShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double
    ' Equivilant to C's Bitwise >> operator
    RShift = CDbl(pnValue \ (2 ^ pnShift))
End Function

Public Sub strcpy(ByRef Source As String, ByVal nText As String)
    Source = Source & nText
End Sub
Public Function GetIconTier(ByVal IconNum As Long, ByVal Race As String) As String
    Select Case Race
        Case "H"
            Select Case IconNum
                Case 1: GetIconTier = "Orc Peon"
                Case 2: GetIconTier = "Footman"
                Case 3: GetIconTier = "Knight"
                Case 4: GetIconTier = "Archmage"
                Case 5: GetIconTier = "Medivh"
                Case Else: GetIconTier = "Unknown Human"
            End Select
        Case "O"
            Select Case IconNum
                Case 1: GetIconTier = "Orc Peon"
                Case 2: GetIconTier = "Grunt"
                Case 3: GetIconTier = "Tauren"
                Case 4: GetIconTier = "Far seer"
                Case 5: GetIconTier = "Thrall"
                Case Else: GetIconTier = "Unknown Orc"
            End Select
        Case "N"
            Select Case IconNum
                Case 1: GetIconTier = "Orc Peon"
                Case 2: GetIconTier = "Archer"
                Case 3: GetIconTier = "Druid of the claw"
                Case 4: GetIconTier = "Priestess of the moon"
                Case 5: GetIconTier = "Furion stomrage"
                Case Else: GetIconTier = "Unknown night elf"
            End Select
        Case "U"
            Select Case IconNum
                Case 1: GetIconTier = "Orc Peon"
                Case 2: GetIconTier = "Ghoul"
                Case 3: GetIconTier = "Abomination"
                Case 4: GetIconTier = "Lich"
                Case 5: GetIconTier = "Tichondrius"
                Case Else: GetIconTier = "Unknown undead"
            End Select
        Case "R"
            Select Case IconNum
                Case 1: GetIconTier = "Orc Peon"
                Case 2: GetIconTier = "Green dragon whelp"
                Case 3: GetIconTier = "Blue dragon"
                Case 4: GetIconTier = "Red dragon"
                Case 5: GetIconTier = "Deathwing"
                Case Else: GetIconTier = "Unknown Random"
            End Select
        Case Else
            GetIconTier = "unknown race"
    End Select
End Function





